/*
 * ResourceUtils.java
 *
 * Created on April 7, 2003, 2:42 PM
 */

package nom.DannyBrewer.utils;

import java.io.*;
import java.awt.Image;
import java.awt.image.*;
import javax.swing.*;
import javax.imageio.*;

import nom.DannyBrewer.utils.ExceptionHandler;

/**
 *
 * @author  danny brewer
 */
public class ResourceLoader {
	private ResourceLoader() {
	}
	
	public static Image getImageResource( String resourcePathname ) {
		Object o = new Object();
		
		// Access a file within this JAR or on the CLASSPATH.
		InputStream inStream = o.getClass().getResourceAsStream( resourcePathname );
		
		BufferedImage image = null;
		try {
			image = ImageIO.read( inStream );
		}
		catch( IOException exc ) {
			ExceptionHandler.unexpectedException( exc );
			return null;
		}
		
		return image;
	}
	
	public static Icon getIconResource( String resourcePathname ) {
		Image image = getImageResource( resourcePathname );
		return new ImageIcon( image );
	}
	
}
